:-module(screenWriting,[mnl/0,mwrite/1,writeStructQuad/6,clearScreen/0]).
:- use_module(library(lists)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Assuming that the main file ensures a dynamic "write_mode/1" predicate is defined.      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


writeStructQuad(A,B,C,D,Arg,Rel) :- mnl, 
	mwrite('Content of this element:'), mnl,
	mwrite('PropNodes: '), mwrite(A), mnl,
	mwrite('OppoNodes: '), mwrite(B), mnl, 
   	mwrite('DefnceAss: '), mwrite(C), mnl,
   	mwrite('Culprits : '), mwrite(D), mnl, 
   	mwrite('Arguments: '), mwrite(Arg), mnl,
   	mwrite('Relations: '), mwrite(Rel), mnl, mnl.

mwrite(_) :- user:write_mode(silent), !.
mwrite(X) :- write(X), writeToLogFile(X). %,user:retract(javaOutput(Before)), append(Before,X,After), user:assert(javaOutput(After)).

mnl :- user:write_mode(silent), !.
mnl :- nl, writeToLogFile('\n'). %, user:retract(javaOutput(Before)), append(Before,"\n",After), user:assert(javaOutput(After)).

clearScreen	:- 	drawNewLines(40).

drawNewLines(0).
drawNewLines(N)	:- N > 0, mnl, NMinusOne is N - 1, drawNewLines(NMinusOne).  

writeToLogFile(X)	:- user:file_name(N), 
%			open('./log.out',append,Stream), 
			open(N,append,Stream), 
			write(Stream,X), 
			close(Stream).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% FROM VICTORS VERSION
%writeStructQuad(A,B,C,D,Arg,Rel) :- mnl, 
%	mwrite("Content of this quadruple:"), mnl,
%	mwrite("PropNodes: "), mwrite_term(A,[quoted(true)]), mnl,
%	mwrite("OppoNodes: "), mwrite_term(B,[quoted(true)]), mnl, 
%   	mwrite("DefnceAss: "), mwrite_term(C,[quoted(true)]), mnl,
%   	mwrite("Culprits : "), mwrite_term(D,[quoted(true)]), mnl, 
%   	mwrite("Arguments: "), mwrite_term(Arg,[quoted(true)]), mnl,
%   	mwrite("Relations: "), mwrite_term(Rel,[quoted(true)]), mnl, mnl.


%mwrite(_) :- user:silent, !.
%mwrite(X) :- write(X), user:retract(javaOutput(Before)), append(Before,X,After), user:assert(javaOutput(After)).

%mnl :- user:silent, !.
%mnl :- nl. % that gets it all in one list ... write("\n").

%mwrite_term(_,_) :- user:silent, !.
%mwrite_term(X,_) :- write_to_chars(X, X2), write(X2), user:retract(javaOutput(Before)), append(Before,X2,After), user:assert(javaOutput(After)).